'''
需求分析：

1.坦克类：
    1.1我方坦克类
    1.2敌方坦克类
    坦克的显示
    坦克的移动
    坦克的射击

2.子弹类：
    子弹的显示
    子弹的移动

3.墙壁类：
    显示墙壁

4.爆炸效果类：
    显示爆炸效果

5.音效类：
    播放音量

6.游戏主窗口类：
    开始游戏
    结束游戏

'''
import pygame
from time import sleep
'''
通用属性
'''
COlor=pygame.Color(0,0,0)
TEXT_COLOR=pygame.Color(255,0,0)
Width=800
Height=600

class Tank:
    def __init__(self,left:int,top:int) -> None:
        '''
        设置我方坦克的资源
        '''
        self.images={ 
      'U':pygame.image.load('E:/tank_game/图片素材/img/p1tankU.gif'),
      'D':pygame.image.load('E:/tank_game/图片素材/img/p1tankD.gif'),
      'L':pygame.image.load('E:/tank_game/图片素材/img/p1tankL.gif'),
      'R':pygame.image.load('E:/tank_game/图片素材/img/p1tankR.gif')
      }
        #设置我方坦克的方向
        self.direction='U'
        #获取图片信息
        self.image=self.images.get(self.direction)
        #获取图片的矩形面积
        self.rect=self.image.get_rect()
        #设置我方坦克的位置
        self.rect.left=left
        self.rect.top=top
        self.speed=30
        self.remove=False

    def display_tank(self) ->None:

        
        '显示坦克'
        self.image = self.images.get(self.direction)
        MainGame.window.blit(self.image,(self.rect.left,self.rect.top))

    def move(self) ->None:

        '坦克的移动'

        if self.direction=='L':
           if self.rect.left>0:
             self.rect.left=self.rect.left-self.speed
        elif self.direction=='R':
           if self.rect.left+self.rect.width<Width:
             self.rect.left=self.rect.left+self.speed
        elif self.direction=='U':
           if self.rect.top>0:       
             self.rect.top=self.rect.top-self.speed
        elif self.direction=='D':
           if self.rect.top+self.rect.height<Height:
             self.rect.top=self.rect.top+self.speed

    def shoot(self):

        '坦克的射击'

        pass

class MyTank(Tank):
    def __init__(self) -> None:
        super().__init__()

    def hitenemytank(self):
        '''
        碰撞敌方坦克
        '''
        pass

class EnemyTank(Tank):
    def __init__(self) -> None:
        super().__init__()

    def hitmytank(self):
        '''
        敌方碰撞我方坦克
        '''
        pass

class Bullet:
  '''
   子弹类
   '''
  def __init__(self) -> None:
    pass
  def display_bullet(self) -> None:
    '''
     显示子弹
     '''
    pass
  def move(self) -> None:
    '''
     子弹的移动
     '''
    pass

class wall:
   
   def __init__(self) -> None:
      pass
   def display_wall(self):
      '显示墙壁'
      pass

class Explode:
  '''
   爆炸效果类
   '''
  def __init__(self) -> None:
    pass
  def display_explode(self) -> None:
    '''
     显示爆炸效果
     '''
    pass

class Music:
  '''
   音效类
   '''
  def __init__(self) -> None:
    pass
  def play_music(self):
    '''
     播放音效
     '''
    pass

class MainGame:
  '''
   游戏主窗口类
   '''
  window=None
  my_tank=None
  def __init__(self) -> None:
    pass
  def start_game(self):
    '''
     开始游戏
     '''
    pygame.display.init()

    MainGame.window=pygame.display.set_mode((Width,Height))
    

    pygame.display.set_caption('坦克大战1.0')
    MainGame.my_tank=Tank(400,300)

    while True:
        sleep(0.02)
        MainGame.window.fill(COlor)

        num = 6
        text=self.get_text_surface(f'敌方坦克剩余数量{num}')
        MainGame.window.blit(text,(10,10))
        self.get_event()
        MainGame.my_tank.display_tank()
        if MainGame.my_tank.remove:
          MainGame.my_tank.move()
        pygame.display.update()
    
  def get_text_surface(self,text:str):
    
    '''
    获取文字图片
    '''
    pygame.font.init()
    '''初始化字体模块
    '''
    font = pygame.font.SysFont('kaiti',18)
    '''
    创建字体
    '''
    text_surface = font.render(text,True,TEXT_COLOR)
    '''
    绘制文本信息
    '''
    return text_surface
  def get_event(self) -> None:
    '''
     获取事件
     '''
    # 获取所有事件
    event_list = pygame.event.get() 
    # 遍历事件
    for event in event_list:
      # 判断是什么事件，然后做出相应的处理
      if event.type == pygame.QUIT:
        # 点击关闭按钮
        self.end_game()
      if event.type == pygame.KEYDOWN:
        # 按下键盘
        if event.key == pygame.K_LEFT:
          print('坦克向左移动')
          MainGame.my_tank.direction='L'
          MainGame.my_tank.remove=True
          
        elif event.key == pygame.K_RIGHT:
          print('坦克向右移动')
          MainGame.my_tank.direction='R'
          MainGame.my_tank.remove=True
         
        elif event.key == pygame.K_UP:
          print('坦克向上移动')
          MainGame.my_tank.direction='U'
          MainGame.my_tank.remove=True
         
        elif event.key == pygame.K_DOWN:
          print('坦克向下移动')
          MainGame.my_tank.direction='D'
          MainGame.my_tank.remove=True
      elif event.type==pygame.KEYUP and event.key in (pygame.K_UP,pygame.K_DOWN,pygame.K_RIGHT,pygame.K_LEFT):
          MainGame.my_tank.remove=False  
  def end_game(self) -> None:
    '''
     结束游戏
     '''
    print('谢谢使用，欢迎再次使用')
    exit()


if __name__=='__main__':
   MainGame().start_game()